AutoWash = {};

AutoWash.metadata = {
	interface = "FS25 ...", 
	title = "AutoWash",
	notes = "Dieser Mod Wäscht alle Fahrzeuge um ~00:00 und 12:00 Uhr. (Auch Missions Fahrzeuge)",
	author = "(by HappyLooser)",
	version = "1.0.0.0",
	build = 5,
	datum = " 22.01.2025",
	update = " 23.04.2025",
	discord = "HappyLooser Modding https://discord.gg/FwktJh4FZ2",
	info = " Link Freigabe,Änderungen,Kopien oder Code Benutzung ist ohne meine Zustimmung nicht erlaubt",
	"##Orginal Link Freigabe:"
};

AutoWash.minDirtAmount = 0.05; --from 5%
AutoWash.washedHours = {0,12,24}; --optional edit here, differenz min 1 also {0,2,4 .....}

function AutoWash:loadMap(mapName)
	print("---loading ".. tostring(AutoWash.metadata.title).. " ".. tostring(AutoWash.metadata.version).. "(#".. tostring(AutoWash.metadata.build).. ") ".. tostring(AutoWash.metadata.author).. "---")	
	AutoWash.canWashing = true;		
	if not AutoWash:isMP() or AutoWash:getDetiServer() or AutoWash:getHostServer() then
		autowash = {};
		function autowash:onHourChanged()
			if AutoWash.canWashing and AutoWash:isWashedHours() then
				local washed = 0;
				for _, vehicle in pairs(g_currentMission.vehicleSystem.vehicles) do
					if vehicle ~= nil and vehicle.finishedLoading == true and vehicle.getDirtAmount ~= nil and vehicle.setDirtAmount ~= nil then						
						local isDirtAmount = vehicle:getDirtAmount() or 0;
						if vehicle.ownerFarmId ~= 0 and isDirtAmount >= AutoWash.minDirtAmount then		
							vehicle:setDirtAmount(0);
							washed = washed+1;
						end;
					end;
				end;
				AutoWash.canWashing = false;				
				if not AutoWash:getDetiServer() and washed > 0 then g_currentMission.hud:addSideNotification(FSBaseMission.INGAME_NOTIFICATION_OK, string.format(g_i18n:getText("washedVehicles"),washed));washed=0;end;
			end;	
			if not AutoWash.canWashing and not AutoWash:isWashedHours() then
				AutoWash.canWashing = true;
			end;		
		end;
		FSBaseMission.onHourChanged = Utils.prependedFunction(FSBaseMission.onHourChanged, autowash.onHourChanged);		
	else	
		print("---".. tostring(AutoWash.metadata.title).. " not loaded for MP Client---");
	end;
end;
addModEventListener(AutoWash);

function AutoWash:getDetiServer()	
	return g_server ~= nil and g_client ~= nil and g_dedicatedServer ~= nil;	
end;

function AutoWash:getHostServer()		
	return g_server ~= nil and g_client ~= nil and g_dedicatedServer == nil and g_currentMission.missionDynamicInfo.isMultiplayer;	
end;

function AutoWash:isMP()		
	return g_currentMission.missionDynamicInfo.isMultiplayer;	
end;

function AutoWash:isWashedHours()
	for h=1, #AutoWash.washedHours do
		if AutoWash.washedHours[h] == g_currentMission.environment.currentHour then return true;end;
	end;
	return false;
end;
